/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;

public class PointedDripstoneBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final DirectionProperty f_154009_ = BlockStateProperties.f_155997_;
    public static final EnumProperty<DripstoneThickness> f_154010_ = BlockStateProperties.f_155998_;
    public static final BooleanProperty f_154011_ = BlockStateProperties.f_61362_;
    private static final int f_154012_ = 11;
    private static final int f_154014_ = 2;
    private static final float f_154015_ = 0.02f;
    private static final float f_154016_ = 0.12f;
    private static final int f_154017_ = 11;
    private static final float f_154018_ = 0.17578125f;
    private static final float f_154019_ = 0.05859375f;
    private static final double f_154020_ = 0.6;
    private static final float f_154021_ = 1.0f;
    private static final int f_154022_ = 40;
    private static final int f_153994_ = 6;
    private static final float f_153995_ = 2.0f;
    private static final int f_153996_ = 2;
    private static final float f_153997_ = 5.0f;
    private static final float f_153998_ = 0.011377778f;
    private static final int f_153999_ = 7;
    private static final int f_154000_ = 10;
    private static final float f_154001_ = 0.6875f;
    private static final VoxelShape f_154002_ = Block.m_49796_(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape f_154003_ = Block.m_49796_(5.0, 0.0, 5.0, 11.0, 11.0, 11.0);
    private static final VoxelShape f_154004_ = Block.m_49796_(5.0, 5.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape f_154005_ = Block.m_49796_(4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
    private static final VoxelShape f_154006_ = Block.m_49796_(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    private static final VoxelShape f_154007_ = Block.m_49796_(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);
    private static final float f_154008_ = 0.125f;
    private static final VoxelShape f_202005_ = Block.m_49796_(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);

    public PointedDripstoneBlock(BlockBehaviour.Properties p_154025_) {
        super(p_154025_);
        this.m_49959_((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_154009_, (Comparable)Direction.UP))).m_61124_((Property)f_154010_, (Comparable)DripstoneThickness.TIP))).m_61124_((Property)f_154011_, Boolean.valueOf(false))));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_154157_) {
        p_154157_.m_61104_(new Property[]{f_154009_, f_154010_, f_154011_});
    }

    @Override
    public boolean m_7898_(BlockState p_154137_, LevelReader p_154138_, BlockPos p_154139_) {
        return PointedDripstoneBlock.m_154221_(p_154138_, p_154139_, (Direction)p_154137_.m_61143_((Property)f_154009_));
    }

    @Override
    public BlockState m_7417_(BlockState p_154147_, Direction p_154148_, BlockState p_154149_, LevelAccessor p_154150_, BlockPos p_154151_, BlockPos p_154152_) {
        if (((Boolean)p_154147_.m_61143_((Property)f_154011_)).booleanValue()) {
            p_154150_.m_186469_(p_154151_, Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)((Object)p_154150_)));
        }
        if (p_154148_ != Direction.UP && p_154148_ != Direction.DOWN) {
            return p_154147_;
        }
        Direction direction = (Direction)p_154147_.m_61143_((Property)f_154009_);
        if (direction == Direction.DOWN && p_154150_.m_183326_().m_183582_(p_154151_, (Object)this)) {
            return p_154147_;
        }
        if (p_154148_ == direction.m_122424_() && !this.m_7898_(p_154147_, (LevelReader)((Object)p_154150_), p_154151_)) {
            if (direction == Direction.DOWN) {
                p_154150_.m_186460_(p_154151_, this, 2);
            } else {
                p_154150_.m_186460_(p_154151_, this, 1);
            }
            return p_154147_;
        }
        boolean flag = p_154147_.m_61143_((Property)f_154010_) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.m_154092_((LevelReader)((Object)p_154150_), p_154151_, direction, flag);
        return (BlockState)((Object)p_154147_.m_61124_((Property)f_154010_, (Comparable)dripstonethickness));
    }

    @Override
    public void m_5581_(Level p_154042_, BlockState p_154043_, BlockHitResult p_154044_, Projectile p_154045_) {
        BlockPos blockpos = p_154044_.m_82425_();
        if (!p_154042_.f_46443_ && p_154045_.m_142265_(p_154042_, blockpos) && p_154045_ instanceof ThrownTrident && p_154045_.m_20184_().m_82553_() > 0.6) {
            if (CraftEventFactory.callEntityChangeBlockEvent((Entity)p_154045_, (BlockPos)blockpos, (BlockState)Blocks.f_50016_.m_49966_()).isCancelled()) {
                return;
            }
            p_154042_.m_46961_(blockpos, true);
        }
    }

    @Override
    public void m_142072_(Level p_154047_, BlockState p_154048_, BlockPos p_154049_, Entity p_154050_, float p_154051_) {
        if (p_154048_.m_61143_((Property)f_154009_) == Direction.UP && p_154048_.m_61143_((Property)f_154010_) == DripstoneThickness.TIP) {
            CraftEventFactory.blockDamage = CraftBlock.at((LevelAccessor)p_154047_, (BlockPos)p_154049_);
            p_154050_.m_142535_(p_154051_ + 2.0f, 2.0f, DamageSource.f_146703_);
            CraftEventFactory.blockDamage = null;
        } else {
            super.m_142072_(p_154047_, p_154048_, p_154049_, p_154050_, p_154051_);
        }
    }

    @Override
    public void m_7100_(BlockState p_154122_, Level p_154123_, BlockPos p_154124_, Random p_154125_) {
        float f;
        if (PointedDripstoneBlock.m_154238_(p_154122_) && !((f = p_154125_.nextFloat()) > 0.12f)) {
            PointedDripstoneBlock.m_154181_(p_154123_, p_154124_, p_154122_).filter(p_154031_ -> f < 0.02f || PointedDripstoneBlock.m_154158_(p_154031_)).ifPresent(p_154220_ -> PointedDripstoneBlock.m_154071_(p_154123_, p_154124_, p_154122_, p_154220_));
        }
    }

    @Override
    public void m_7458_(BlockState p_154107_, ServerLevel p_154108_, BlockPos p_154109_, Random p_154110_) {
        if (PointedDripstoneBlock.m_154242_(p_154107_) && !this.m_7898_(p_154107_, (LevelReader)((Object)p_154108_), p_154109_)) {
            p_154108_.m_46961_(p_154109_, true);
        } else {
            PointedDripstoneBlock.m_154097_(p_154107_, p_154108_, p_154109_);
        }
    }

    @Override
    public void m_7455_(BlockState p_154199_, ServerLevel p_154200_, BlockPos p_154201_, Random p_154202_) {
        PointedDripstoneBlock.m_154101_(p_154199_, p_154200_, p_154201_, p_154202_.nextFloat());
        if (p_154202_.nextFloat() < 0.011377778f && PointedDripstoneBlock.m_154203_(p_154199_, (LevelReader)((Object)p_154200_), p_154201_)) {
            PointedDripstoneBlock.m_154225_(p_154199_, p_154200_, p_154201_, p_154202_);
        }
    }

    @VisibleForTesting
    public static void m_154101_(BlockState p_154102_, ServerLevel p_154103_, BlockPos p_154104_, float p_154105_) {
        if (!(p_154105_ > 0.17578125f && p_154105_ > 0.05859375f || !PointedDripstoneBlock.m_154203_(p_154102_, (LevelReader)((Object)p_154103_), p_154104_))) {
            BlockPos blockpos1;
            BlockPos blockpos;
            float f;
            Fluid fluid = PointedDripstoneBlock.m_154178_(p_154103_, p_154104_);
            if (fluid == Fluids.f_76193_) {
                f = 0.17578125f;
            } else {
                if (fluid != Fluids.f_76195_) {
                    return;
                }
                f = 0.05859375f;
            }
            if (!(p_154105_ >= f) && (blockpos = PointedDripstoneBlock.m_154130_(p_154102_, p_154103_, p_154104_, 11, false)) != null && (blockpos1 = PointedDripstoneBlock.m_154076_(p_154103_, blockpos, fluid)) != null) {
                p_154103_.m_46796_(1504, blockpos, 0);
                int i = blockpos.m_123342_() - blockpos1.m_123342_();
                int j = 50 + i;
                BlockState blockstate = p_154103_.m_8055_(blockpos1);
                p_154103_.m_186460_(blockpos1, blockstate.m_60734_(), j);
            }
        }
    }

    @Override
    public PushReaction m_5537_(BlockState p_154237_) {
        return PushReaction.DESTROY;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_154040_) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = p_154040_.m_43725_();
        Direction direction1 = PointedDripstoneBlock.m_154190_((LevelReader)((Object)levelaccessor), blockpos = p_154040_.m_8083_(), direction = p_154040_.m_151260_().m_122424_());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !p_154040_.m_7078_();
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.m_154092_((LevelReader)((Object)levelaccessor), blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.m_49966_().m_61124_((Property)f_154009_, (Comparable)direction1))).m_61124_((Property)f_154010_, (Comparable)dripstonethickness))).m_61124_((Property)f_154011_, Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_)));
    }

    @Override
    public FluidState m_5888_(BlockState p_154235_) {
        return (Boolean)p_154235_.m_61143_((Property)f_154011_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_154235_);
    }

    @Override
    public VoxelShape m_7952_(BlockState p_154170_, BlockGetter p_154171_, BlockPos p_154172_) {
        return Shapes.m_83040_();
    }

    @Override
    public VoxelShape m_5940_(BlockState p_154117_, BlockGetter p_154118_, BlockPos p_154119_, CollisionContext p_154120_) {
        DripstoneThickness dripstonethickness = (DripstoneThickness)p_154117_.m_61143_((Property)f_154010_);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? f_154002_ : (dripstonethickness == DripstoneThickness.TIP ? (p_154117_.m_61143_((Property)f_154009_) == Direction.DOWN ? f_154004_ : f_154003_) : (dripstonethickness == DripstoneThickness.FRUSTUM ? f_154005_ : (dripstonethickness == DripstoneThickness.MIDDLE ? f_154006_ : f_154007_)));
        Vec3 vec3 = p_154117_.m_60824_(p_154118_, p_154119_);
        return voxelshape.m_83216_(vec3.f_82479_, 0.0, vec3.f_82481_);
    }

    @Override
    public boolean m_180643_(BlockState p_181235_, BlockGetter p_181236_, BlockPos p_181237_) {
        return false;
    }

    @Override
    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    @Override
    public float m_142740_() {
        return 0.125f;
    }

    public void m_142525_(Level p_154059_, BlockPos p_154060_, FallingBlockEntity p_154061_) {
        if (!p_154061_.m_20067_()) {
            p_154059_.m_46796_(1045, p_154060_, 0);
        }
    }

    public DamageSource m_142088_() {
        return DamageSource.f_146702_;
    }

    public Predicate<Entity> m_142398_() {
        return EntitySelector.f_20406_.and(EntitySelector.f_20403_);
    }

    private static void m_154097_(BlockState p_154098_, ServerLevel p_154099_, BlockPos p_154100_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_154100_.m_122032_();
        BlockState blockstate = p_154098_;
        while (PointedDripstoneBlock.m_154240_(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_(p_154099_, (BlockPos)blockpos$mutableblockpos, blockstate);
            if (PointedDripstoneBlock.m_154153_(blockstate, true)) {
                int i = Math.max(1 + p_154100_.m_123342_() - blockpos$mutableblockpos.m_123342_(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.m_149656_(f, 40);
                break;
            }
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            blockstate = p_154099_.m_8055_((BlockPos)blockpos$mutableblockpos);
        }
    }

    @VisibleForTesting
    public static void m_154225_(BlockState p_154226_, ServerLevel p_154227_, BlockPos p_154228_, Random p_154229_) {
        BlockState blockstate2;
        BlockPos blockpos;
        BlockState blockstate1;
        BlockState blockstate = p_154227_.m_8055_(p_154228_.m_6630_(1));
        if (PointedDripstoneBlock.m_154140_(blockstate, blockstate1 = p_154227_.m_8055_(p_154228_.m_6630_(2))) && (blockpos = PointedDripstoneBlock.m_154130_(p_154226_, p_154227_, p_154228_, 7, false)) != null && PointedDripstoneBlock.m_154238_(blockstate2 = p_154227_.m_8055_(blockpos)) && PointedDripstoneBlock.m_154194_(blockstate2, p_154227_, blockpos)) {
            if (p_154229_.nextBoolean()) {
                PointedDripstoneBlock.m_154035_(p_154227_, blockpos, Direction.DOWN);
            } else {
                PointedDripstoneBlock.m_154032_(p_154227_, blockpos);
            }
        }
    }

    private static void m_154032_(ServerLevel p_154033_, BlockPos p_154034_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_154034_.m_122032_();
        for (int i = 0; i < 10; ++i) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            BlockState blockstate = p_154033_.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (!blockstate.m_60819_().m_76178_()) {
                return;
            }
            if (PointedDripstoneBlock.m_154143_(blockstate, Direction.UP) && PointedDripstoneBlock.m_154194_(blockstate, p_154033_, (BlockPos)blockpos$mutableblockpos)) {
                PointedDripstoneBlock.m_154035_(p_154033_, (BlockPos)blockpos$mutableblockpos, Direction.UP);
                return;
            }
            if (PointedDripstoneBlock.m_154221_((LevelReader)((Object)p_154033_), (BlockPos)blockpos$mutableblockpos, Direction.UP) && !p_154033_.m_46801_(blockpos$mutableblockpos.m_7495_())) {
                PointedDripstoneBlock.m_154035_(p_154033_, blockpos$mutableblockpos.m_7495_(), Direction.UP);
                return;
            }
            if (PointedDripstoneBlock.m_202017_((BlockGetter)((Object)p_154033_), (BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return;
        }
    }

    private static void m_154035_(ServerLevel p_154036_, BlockPos p_154037_, Direction p_154038_) {
        BlockPos blockpos = p_154037_.m_142300_(p_154038_);
        BlockState blockstate = p_154036_.m_8055_(blockpos);
        if (PointedDripstoneBlock.m_154143_(blockstate, p_154038_.m_122424_())) {
            PointedDripstoneBlock.m_154230_(blockstate, p_154036_, blockpos);
        } else if (blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_49990_)) {
            PointedDripstoneBlock.createDripstone(p_154036_, blockpos, p_154038_, DripstoneThickness.TIP, p_154037_);
        }
    }

    private static void createDripstone(LevelAccessor p_154088_, BlockPos p_154089_, Direction p_154090_, DripstoneThickness p_154091_, BlockPos source) {
        BlockState blockstate = (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)Blocks.f_152588_.m_49966_().m_61124_((Property)f_154009_, (Comparable)p_154090_))).m_61124_((Property)f_154010_, (Comparable)p_154091_))).m_61124_((Property)f_154011_, Boolean.valueOf(p_154088_.m_6425_(p_154089_).m_76152_() == Fluids.f_76193_)));
        CraftEventFactory.handleBlockSpreadEvent((LevelAccessor)p_154088_, (BlockPos)source, (BlockPos)p_154089_, (BlockState)blockstate, (int)3);
    }

    private static void m_154230_(BlockState p_154231_, LevelAccessor p_154232_, BlockPos p_154233_) {
        BlockPos blockpos;
        BlockPos blockpos1;
        if (p_154231_.m_61143_((Property)f_154009_) == Direction.UP) {
            blockpos1 = p_154233_;
            blockpos = p_154233_.m_7494_();
        } else {
            blockpos = p_154233_;
            blockpos1 = p_154233_.m_7495_();
        }
        PointedDripstoneBlock.createDripstone(p_154232_, blockpos, Direction.DOWN, DripstoneThickness.TIP_MERGE, p_154233_);
        PointedDripstoneBlock.createDripstone(p_154232_, blockpos1, Direction.UP, DripstoneThickness.TIP_MERGE, p_154233_);
    }

    public static void m_154062_(Level p_154063_, BlockPos p_154064_, BlockState p_154065_) {
        PointedDripstoneBlock.m_154181_(p_154063_, p_154064_, p_154065_).ifPresent(p_154189_ -> PointedDripstoneBlock.m_154071_(p_154063_, p_154064_, p_154065_, p_154189_));
    }

    private static void m_154071_(Level p_154072_, BlockPos p_154073_, BlockState p_154074_, Fluid p_154075_) {
        Vec3 vec3 = p_154074_.m_60824_((BlockGetter)((Object)p_154072_), p_154073_);
        double d0 = 0.0625;
        double d1 = (double)p_154073_.m_123341_() + 0.5 + vec3.f_82479_;
        double d2 = (double)((float)(p_154073_.m_123342_() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)p_154073_.m_123343_() + 0.5 + vec3.f_82481_;
        Fluid fluid = PointedDripstoneBlock.m_154052_(p_154072_, p_154075_);
        SimpleParticleType particleoptions = fluid.m_205067_(FluidTags.f_13132_) ? ParticleTypes.f_175822_ : ParticleTypes.f_175824_;
        p_154072_.m_7106_((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos m_154130_(BlockState p_154131_, LevelAccessor p_154132_, BlockPos p_154133_, int p_154134_, boolean p_154135_) {
        if (PointedDripstoneBlock.m_154153_(p_154131_, p_154135_)) {
            return p_154133_;
        }
        Direction direction = (Direction)p_154131_.m_61143_((Property)f_154009_);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202023_, p_202024_) -> p_202024_.m_60713_(Blocks.f_152588_) && p_202024_.m_61143_((Property)f_154009_) == direction;
        return PointedDripstoneBlock.m_202006_(p_154132_, p_154133_, direction.m_122421_(), bipredicate, p_154168_ -> PointedDripstoneBlock.m_154153_(p_154168_, p_154135_), p_154134_).orElse(null);
    }

    @Nullable
    private static Direction m_154190_(LevelReader p_154191_, BlockPos p_154192_, Direction p_154193_) {
        Direction direction;
        if (PointedDripstoneBlock.m_154221_(p_154191_, p_154192_, p_154193_)) {
            direction = p_154193_;
        } else {
            if (!PointedDripstoneBlock.m_154221_(p_154191_, p_154192_, p_154193_.m_122424_())) {
                return null;
            }
            direction = p_154193_.m_122424_();
        }
        return direction;
    }

    private static DripstoneThickness m_154092_(LevelReader p_154093_, BlockPos p_154094_, Direction p_154095_, boolean p_154096_) {
        Direction direction = p_154095_.m_122424_();
        BlockState blockstate = p_154093_.m_8055_(p_154094_.m_142300_(p_154095_));
        if (PointedDripstoneBlock.m_154207_(blockstate, direction)) {
            return !p_154096_ && blockstate.m_61143_((Property)f_154010_) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!PointedDripstoneBlock.m_154207_(blockstate, p_154095_)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.m_61143_((Property)f_154010_);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = p_154093_.m_8055_(p_154094_.m_142300_(direction));
            return !PointedDripstoneBlock.m_154207_(blockstate1, p_154095_) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean m_154238_(BlockState p_154239_) {
        return PointedDripstoneBlock.m_154240_(p_154239_) && p_154239_.m_61143_((Property)f_154010_) == DripstoneThickness.TIP && (Boolean)p_154239_.m_61143_((Property)f_154011_) == false;
    }

    private static boolean m_154194_(BlockState p_154195_, ServerLevel p_154196_, BlockPos p_154197_) {
        Direction direction = (Direction)p_154195_.m_61143_((Property)f_154009_);
        BlockPos blockpos = p_154197_.m_142300_(direction);
        BlockState blockstate = p_154196_.m_8055_(blockpos);
        if (!blockstate.m_60819_().m_76178_()) {
            return false;
        }
        return blockstate.m_60795_() ? true : PointedDripstoneBlock.m_154143_(blockstate, direction.m_122424_());
    }

    private static Optional<BlockPos> m_154066_(Level p_154067_, BlockPos p_154068_, BlockState p_154069_, int p_154070_) {
        Direction direction = (Direction)p_154069_.m_61143_((Property)f_154009_);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202015_, p_202016_) -> p_202016_.m_60713_(Blocks.f_152588_) && p_202016_.m_61143_((Property)f_154009_) == direction;
        return PointedDripstoneBlock.m_202006_(p_154067_, p_154068_, direction.m_122424_().m_122421_(), bipredicate, p_154245_ -> !p_154245_.m_60713_(Blocks.f_152588_), p_154070_);
    }

    private static boolean m_154221_(LevelReader p_154222_, BlockPos p_154223_, Direction p_154224_) {
        BlockPos blockpos = p_154223_.m_142300_(p_154224_.m_122424_());
        BlockState blockstate = p_154222_.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)((Object)p_154222_), blockpos, p_154224_) || PointedDripstoneBlock.m_154207_(blockstate, p_154224_);
    }

    private static boolean m_154153_(BlockState p_154154_, boolean p_154155_) {
        if (!p_154154_.m_60713_(Blocks.f_152588_)) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)p_154154_.m_61143_((Property)f_154010_);
        return dripstonethickness == DripstoneThickness.TIP || p_154155_ && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean m_154143_(BlockState p_154144_, Direction p_154145_) {
        return PointedDripstoneBlock.m_154153_(p_154144_, false) && p_154144_.m_61143_((Property)f_154009_) == p_154145_;
    }

    private static boolean m_154240_(BlockState p_154241_) {
        return PointedDripstoneBlock.m_154207_(p_154241_, Direction.DOWN);
    }

    private static boolean m_154242_(BlockState p_154243_) {
        return PointedDripstoneBlock.m_154207_(p_154243_, Direction.UP);
    }

    private static boolean m_154203_(BlockState p_154204_, LevelReader p_154205_, BlockPos p_154206_) {
        return PointedDripstoneBlock.m_154240_(p_154204_) && !p_154205_.m_8055_(p_154206_.m_7494_()).m_60713_(Blocks.f_152588_);
    }

    @Override
    public boolean m_7357_(BlockState p_154112_, BlockGetter p_154113_, BlockPos p_154114_, PathComputationType p_154115_) {
        return false;
    }

    private static boolean m_154207_(BlockState p_154208_, Direction p_154209_) {
        return p_154208_.m_60713_(Blocks.f_152588_) && p_154208_.m_61143_((Property)f_154009_) == p_154209_;
    }

    @Nullable
    private static BlockPos m_154076_(Level p_154077_, BlockPos p_154078_, Fluid p_154079_) {
        Predicate<BlockState> predicate = p_154162_ -> p_154162_.m_60734_() instanceof AbstractCauldronBlock && ((AbstractCauldronBlock)p_154162_.m_60734_()).m_142087_(p_154079_);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202034_, p_202035_) -> PointedDripstoneBlock.m_202017_((BlockGetter)((Object)p_154077_), p_202034_, p_202035_);
        return PointedDripstoneBlock.m_202006_(p_154077_, p_154078_, Direction.DOWN.m_122421_(), bipredicate, predicate, 11).orElse(null);
    }

    @Nullable
    public static BlockPos m_154055_(Level p_154056_, BlockPos p_154057_) {
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202030_, p_202031_) -> PointedDripstoneBlock.m_202017_((BlockGetter)((Object)p_154056_), p_202030_, p_202031_);
        return PointedDripstoneBlock.m_202006_(p_154056_, p_154057_, Direction.UP.m_122421_(), bipredicate, PointedDripstoneBlock::m_154238_, 11).orElse(null);
    }

    public static Fluid m_154178_(Level p_154179_, BlockPos p_154180_) {
        return PointedDripstoneBlock.m_154181_(p_154179_, p_154180_, p_154179_.m_8055_(p_154180_)).filter(PointedDripstoneBlock::m_154158_).orElse(Fluids.f_76191_);
    }

    private static Optional<Fluid> m_154181_(Level p_154182_, BlockPos p_154183_, BlockState p_154184_) {
        return !PointedDripstoneBlock.m_154240_(p_154184_) ? Optional.empty() : PointedDripstoneBlock.m_154066_(p_154182_, p_154183_, p_154184_, 11).map(p_202027_ -> p_154182_.m_6425_(p_202027_.m_7494_()).m_76152_());
    }

    private static boolean m_154158_(Fluid p_154159_) {
        return p_154159_ == Fluids.f_76195_ || p_154159_ == Fluids.f_76193_;
    }

    private static boolean m_154140_(BlockState p_154141_, BlockState p_154142_) {
        return p_154141_.m_60713_(Blocks.f_152537_) && p_154142_.m_60713_(Blocks.f_49990_) && p_154142_.m_60819_().m_76170_();
    }

    private static Fluid m_154052_(Level p_154053_, Fluid p_154054_) {
        if (p_154054_.m_6212_(Fluids.f_76191_)) {
            return p_154053_.m_6042_().m_63951_() ? Fluids.f_76195_ : Fluids.f_76193_;
        }
        return p_154054_;
    }

    private static Optional<BlockPos> m_202006_(LevelAccessor p_202007_, BlockPos p_202008_, Direction.AxisDirection p_202009_, BiPredicate<BlockPos, BlockState> p_202010_, Predicate<BlockState> p_202011_, int p_202012_) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)p_202009_, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_202008_.m_122032_();
        for (int i = 1; i < p_202012_; ++i) {
            blockpos$mutableblockpos.m_122173_(direction);
            BlockState blockstate = p_202007_.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (p_202011_.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.m_7949_());
            }
            if (!p_202007_.m_151562_(blockpos$mutableblockpos.m_123342_()) && p_202010_.test((BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean m_202017_(BlockGetter p_202018_, BlockPos p_202019_, BlockState p_202020_) {
        if (p_202020_.m_60795_()) {
            return true;
        }
        if (p_202020_.m_60804_(p_202018_, p_202019_)) {
            return false;
        }
        if (!p_202020_.m_60819_().m_76178_()) {
            return false;
        }
        VoxelShape voxelshape = p_202020_.m_60812_(p_202018_, p_202019_);
        return !Shapes.m_83157_(f_202005_, voxelshape, BooleanOp.f_82689_);
    }
}

